<x-user.content>
    <x-slot:title>eCommerce MM</x-slot:title>
    <x-slot:head>
        <style>
            @media only screen and (max-width: 600px) {
                .tgest tr th {
                    font-size: 10px !important;
                    padding: 5PX;
                }

                .tgest tr td {
                    font-size: 10px !important;
                    padding: 5PX;
                }

                .tgest tr td button,
                input {
                    font-size: 10px !important;
                    padding: 5PX;
                }


                .tgest tr td img {
                    width: 10px;
                    padding: 3PX;
                }

                .tgest tr td .input-group {
                    width: 80px !important;
                    padding: 3PX;
                }
            }
        </style>
    </x-slot:head>
    <div class="container-fluid">
        <div class="row px-xl-5">
            <div class="col-12">
                <nav class="breadcrumb bg-light mb-30">
                    <a class="breadcrumb-item text-dark" href="/">Home</a>
                    <span class="breadcrumb-item active">Keranjang Belanja</span>
                </nav>
                <x-message></x-message>
            </div>
        </div>
    </div>

    <div class="container-fluid">

        @if (Cart::count() > 0)
            <div class="row px-xl-5 ">
                <div class="col-lg-8 table-responsive mb-5">
                    <table class="table table-light table-borderless table-hover text-center mb-0 tgest">
                        <thead class="thead-dark">
                            <tr>
                                <th colspan="2">Produk</th>
                                <th>Harga</th>
                                <th width="1%">Qty</th>
                                <th>Total</th>
                                <th>Hapus</th>
                            </tr>
                        </thead>
                        <tbody class="align-middle" id="cart_item">
                            @foreach (Cart::content() as $row)
                                <tr>
                                    <td style="width: 10%">
                                        <img src="{{ asset('/storage/produk') }}/{{ produk($row->id)->gambar }}"
                                            alt="" style="width: 50px;">
                                    </td>
                                    <td class="align-middle text-left">
                                        {{ $row->name }}
                                    </td>
                                    <td class="align-middle">{{ number_format($row->price, 0, ',', '.') }}</td>
                                    <td class="align-middle">
                                        <div class="input-group quantity mx-auto" style="width: 100px;">
                                            <div class="input-group-btn">
                                                <button class="btn btn-sm btn-danger btn-minus qty_update"
                                                    data-nm="minus" data-id="{{ $row->rowId }}"
                                                    data-idp="{{ $row->id }}">
                                                    <i class="fa fa-minus"></i>
                                                </button>
                                            </div>
                                            <input type="text"
                                                class="form-control form-control-sm bg-secondary border-0 text-center"
                                                value="{{ $row->qty }}">
                                            <div class="input-group-btn">
                                                <button class="btn btn-sm btn-success btn-plus qty_update"
                                                    data-nm="plus" data-id="{{ $row->rowId }}"
                                                    data-idp="{{ $row->id }}">
                                                    <i class="fa fa-plus"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="align-middle">{{ number_format($row->price * $row->qty, 0, ',', '.') }}
                                    </td>
                                    <td class="align-middle"><button class="btn btn-sm btn-danger hapus_item"
                                            data-id="{{ $row->rowId }}"><i class="fa fa-times"></i></button>
                                    </td>
                                </tr>
                            @endforeach


                        </tbody>
                    </table>
                </div>
                <div class="col-lg-4">
                    {{-- <div class="alert alert-warning">
                        <strong>Perhatian!</strong> <br> Total harga dibawah belum termasuk Ongkir.
                    </div> --}}
                    {{-- <form class="mb-30" action="">
                    <div class="input-group">
                        <input type="text" class="form-control border-0 p-4" placeholder="Coupon Code">
                        <div class="input-group-append">
                            <button class="btn btn-primary">Apply Coupon</button>
                        </div>
                    </div>
                </form> --}}
                    <h5 class="section-title position-relative text-uppercase mb-3"><span
                            class="bg-secondary pr-3">Total
                            Pesanan</span></h5>
                    <div class="bg-light p-30 mb-5">
                        <div class="border-bottom pb-2">
                            <div class="d-flex justify-content-between mb-3">
                                <h6>Jumlah </h6>
                                <h6>{{ Cart::count() }} Item</h6>
                            </div>
                            {{-- <div class="d-flex justify-content-between">
                            <h6 class="font-weight-medium">Shipping</h6>
                            <h6 class="font-weight-medium">$10</h6>
                        </div> --}}
                        </div>
                        <div class="pt-2">
                            <div class="d-flex justify-content-between mt-2">
                                <h5>Total</h5>
                                <h5>Rp. {{ Cart::subtotal() }}</h5>
                            </div>
                            <a href="/checkout" class="btn btn-block btn-success font-weight-bold my-3 py-3">Buat
                                Pesanan</a>

                            <a href="/list-produk" class="btn btn-block btn-primary font-weight-bold my-3 py-3">Belanja
                                Lagi</a>
                        </div>
                    </div>
                </div>
            </div>
        @else
            <div class="row px-xl-5 justify-content-center">
                <div class="col-lg-4">
                    <a href="/list-produk" class="btn btn-block btn-primary font-weight-bold my-3 py-3"><i
                            class="fa fa-cart-plus"></i> Cari Produk</a>
                </div>
            </div>
        @endif
    </div>

    <div class="container vh-100"></div>

    <x-slot:foot>

    </x-slot:foot>
</x-user.content>
